/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.time;

import com.ibm.hwmca.base.time.CustConDateTimeBeanData;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class CustConDateTimeBean
extends PanelBean {
    private static final String TRACE_MASKT = "XTODCOBT";
    private static final String TRACE_MASKF = "XTODCOBF";
    private static final String TRACE_MASKD = "XTODCOBD";
    private CustConDateTimeBeanData beanData;
    private Calendar m_cTimeNumber;
    private Calendar m_cDateNumber;
    private double m_dHoursNumber;
    private double m_dMinutesNumber;
    private String[] m_sDirectionChoiceSelection;
    public static String DIRECTION_CHOICE_EAST = "EastItem";
    public static String DIRECTION_CHOICE_WEST = "WestItem";
    private boolean canceled = false;
    private TimeZone serverTimeZone;

    public CustConDateTimeBean(CustConDateTimeBeanData data) {
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBean ctor(" + data + ")");
        this.beanData = data;
        this.load();
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean ctor");
    }

    public Calendar getTimeNumber() {
        return this.m_cTimeNumber;
    }

    public void setTimeNumber(Calendar c) throws IllegalUserDataException {
        this.m_cTimeNumber = c;
        this.m_cTimeNumber.setTimeZone(this.serverTimeZone);
    }

    public Calendar getDateNumber() {
        return this.m_cDateNumber;
    }

    public void setDateNumber(Calendar c) throws IllegalUserDataException {
        this.m_cDateNumber = c;
        this.m_cDateNumber.setTimeZone(this.serverTimeZone);
    }

    public double getHoursNumber() {
        return this.m_dHoursNumber;
    }

    public void setHoursNumber(double d) throws IllegalUserDataException {
        this.m_dHoursNumber = d;
    }

    public double getMinutesNumber() {
        return this.m_dMinutesNumber;
    }

    public void setMinutesNumber(double d) throws IllegalUserDataException {
        this.m_dMinutesNumber = d;
    }

    public String[] getDirectionChoiceSelection() {
        return this.m_sDirectionChoiceSelection;
    }

    public void setDirectionChoiceSelection(String[] selected) throws IllegalUserDataException {
        this.m_sDirectionChoiceSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBean.load()");
        this.m_cTimeNumber = this.beanData.getTimeNumber();
        this.m_cDateNumber = this.beanData.getDateNumber();
        this.m_dHoursNumber = this.beanData.getHoursNumber();
        this.m_dMinutesNumber = this.beanData.getMinutesNumber();
        this.m_sDirectionChoiceSelection = this.beanData.getDirectionChoiceSelection();
        this.serverTimeZone = this.m_cTimeNumber.getTimeZone();
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.load()");
    }

    public void panelAction(TaskActionEvent event) {
        String command = event.getActionCommand();
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBean.panelAction() for command = " + command);
        if (command.equals("CANCEL")) {
            this.canceled = true;
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", event);
            this.postTaskletRequest(request);
        } else if (command.equals("CustomizeButton")) {
            this.userTaskManager.storeAllElements();
            Trace.trace(TRACE_MASKF, "   Handling Customize button.  Updated bean=" + this);
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", event);
            CustConDateTimeBeanData newBeanData = new CustConDateTimeBeanData(this.m_cTimeNumber, this.m_cDateNumber, this.m_dHoursNumber, this.m_dMinutesNumber, this.m_sDirectionChoiceSelection);
            request.setData("beanData", newBeanData);
            this.userTaskManager.refreshAllElements();
            Trace.trace(TRACE_MASKF, "   About to send new beanData: " + newBeanData);
            this.postTaskletRequest(request);
        } else if (command.equals("RefreshButton")) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", event);
            this.postTaskletRequest(request);
        } else {
            Trace.trace(TRACE_MASKF, "   Unrecognized action command: " + command);
        }
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.panelAction()");
    }

    public void update(Object newData) {
        Trace.trace(TRACE_MASKT, "-> CustConDateTimeBean.update()");
        if (this.canceled) {
            Trace.trace(TRACE_MASKF, "   Ignoring update request due to previous cancel command");
        } else {
            this.beanData = (CustConDateTimeBeanData)newData;
            this.load();
            Trace.trace(TRACE_MASKF, "   About to refreshAllElements(); bean=" + this.toString());
            this.userTaskManager.refreshAllElements();
        }
        Trace.trace(TRACE_MASKT, "<- CustConDateTimeBean.update()");
    }

    public String toString() {
        ClientUserContext userContext;
        StringBuffer sb = new StringBuffer();
        DateFormat df = null;
        df = DateFormat.getTimeInstance(0);
        df.setTimeZone(this.m_cTimeNumber.getTimeZone());
        Trace.trace(TRACE_MASKF, "   toString: Time = " + df.format(this.m_cTimeNumber.getTime()));
        Trace.trace(TRACE_MASKF, "   toString: TimeZone = " + this.m_cTimeNumber.getTimeZone());
        Trace.trace(TRACE_MASKF, "   toString: m_cTimeNumber = " + this.m_cTimeNumber);
        try {
            userContext = ClientUserContext.getUserContext();
            df = DateFormat.getTimeInstance(2, userContext.getLocale());
            df.setTimeZone(userContext.getTimeZone());
        }
        catch (NullContextException e) {
            df = DateFormat.getTimeInstance();
        }
        sb.append("Time=" + df.format(this.m_cTimeNumber.getTime()));
        df = DateFormat.getDateInstance(0);
        df.setTimeZone(this.m_cDateNumber.getTimeZone());
        Trace.trace(TRACE_MASKF, "   toString: Date = " + df.format(this.m_cDateNumber.getTime()));
        Trace.trace(TRACE_MASKF, "   toString: TimeZone = " + this.m_cDateNumber.getTimeZone());
        Trace.trace(TRACE_MASKF, "   toString: m_cDateNumber = " + this.m_cDateNumber);
        try {
            userContext = ClientUserContext.getUserContext();
            df = DateFormat.getDateInstance(2, userContext.getLocale());
            df.setTimeZone(userContext.getTimeZone());
        }
        catch (NullContextException e) {
            df = DateFormat.getDateInstance();
        }
        sb.append("; Date=" + df.format(this.m_cDateNumber.getTime()));
        sb.append("; UTC offset = " + this.m_dHoursNumber + " hours");
        sb.append(" and " + this.m_dMinutesNumber + " minutes");
        if (this.m_sDirectionChoiceSelection.length == 0) {
            sb.append("; direction unknown");
        } else {
            sb.append(this.m_sDirectionChoiceSelection[0].equals(DIRECTION_CHOICE_EAST) ? " East." : " West.");
        }
        return sb.toString();
    }
}

